/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.ntutil;

import filenet.vw.ntutil.VWNTUTIL_DLL;

public class PEBytePointer {
    private long ptr = 0L;
    private int avail_sz = 0;
    private int used_sz = 0;

    private native long malloc_me(int var1);

    private native void free_me();

    private native boolean copy_me(byte[] var1, int var2);

    private native boolean set_me(byte[] var1, int var2);

    private static native void initIDs();

    public void free() {
        if (this.avail_sz > 0) {
            this.free_me();
        }
        this.avail_sz = 0;
        this.used_sz = 0;
    }

    public PEBytePointer(int size) {
        if (size > 0) {
            this.ptr = this.malloc_me(size);
            if (this.ptr == 0L) {
                throw new OutOfMemoryError();
            }
        }
        this.avail_sz = size;
        this.used_sz = 0;
    }

    public byte[] getBytes() {
        byte[] results = new byte[this.used_sz];
        if (this.used_sz > 0 && !this.copy_me(results, this.used_sz)) {
            throw new RuntimeException("Unable to copy buffer!");
        }
        return results;
    }

    public void setBytes(byte[] inBuf) {
        int nBytes;
        int n = nBytes = inBuf == null ? 0 : inBuf.length;
        if (nBytes > 0) {
            if (nBytes > this.avail_sz) {
                throw new ArrayIndexOutOfBoundsException();
            }
            if (!this.set_me(inBuf, nBytes)) {
                throw new RuntimeException("Unable to set buffer!");
            }
        }
        this.used_sz = nBytes;
    }

    public void setUsedSize(int sz) {
        this.used_sz = sz;
    }

    private static void error(String msg) {
        System.err.println(msg);
        System.exit(1);
    }

    private static void msg(String message) {
        System.out.println(message);
    }

    public static void main(String[] args) {
        int nBytes2;
        PEBytePointer p1 = new PEBytePointer(200);
        byte[] b1 = new byte[100];
        for (int i = 0; i < b1.length; ++i) {
            b1[i] = 48;
        }
        p1.setBytes(b1);
        PEBytePointer.msg("Able to setBytes..");
        byte[] b2 = p1.getBytes();
        int n = nBytes2 = b2 == null ? 0 : b2.length;
        if (b1.length != nBytes2) {
            PEBytePointer.error("setBytes Failed!!");
        } else {
            PEBytePointer.msg("Good job, getBytes return same length as setBytes");
        }
        for (int i = 0; i < nBytes2; ++i) {
            if (b1[i] == b2[i]) continue;
            PEBytePointer.error("Byte mismatched found at " + i);
        }
        PEBytePointer.msg("Good job, bytes matched!");
        p1.free();
        PEBytePointer.msg("Free bytes.. should not be able to setBytes..");
        try {
            p1.setBytes(b1);
            PEBytePointer.error("Shoud be an error of ArrayIndexOutOfBound!!");
        }
        catch (Throwable t) {
            System.out.println("Expected exception:  " + t);
        }
    }

    static {
        if (VWNTUTIL_DLL.initLibrary()) {
            PEBytePointer.initIDs();
        }
    }
}

